/******************************************************************************/
class CheckBool : BaseCheckVariable
{
public:
    CheckBool();
   ~CheckBool();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      );
   
private:

   void CallTriggeredAction();
   void StopTriggeredAction() {}
   
   UID m_BoolUID;
   
   VarBool* m_VarBool;
};
/******************************************************************************/
CheckBool::CheckBool() : m_VarBool(null)                
{

}
CheckBool::~CheckBool()
{
   
}
/******************************************************************************/
void CheckBool::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarBoolUID"))          m_BoolUID  = p.asID();
   if(Param *p = obj.findParam("False_EventGroupUID")) m_FalseUID = p.asID();
   if(Param *p = obj.findParam("True_EventGroupUID"))  m_TrueUID  = p.asID();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void CheckBool::AfterCreate()
{
   super.AfterCreate();
   
   // Find the correct VarBool to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesBool)
      if(variablesBool[i].id() == m_BoolUID)
         m_VarBool = &variablesBool[i];
         
   DEBUG_ASSERT(m_VarBool, "VarBool not found in scene");
}
/******************************************************************************/
void CheckBool::CallTriggeredAction()
{
   // Check if the bool is true or false (This can change during runtime)
   if(m_VarBool.GetValue()) 
      TriggerTrueCondition();
   else     
      TriggerFalseCondition();
}
/******************************************************************************/